﻿<#WaaS Info Script Phase 2 of 2.  
#Phase 2 is at end of TS, grabs basic info and writes to registry.
#
#  IPU Keys:
#   IPUReturnStatus
#   IPUReturnCode
#   IPURuntime
#   IPUSetuptime
#   IPUBuild
#   IPUFailedAttempts - IF TS FAILS
#   IPUFailedStepReturnCode
#   IPUFailedStepName
#   WaaS_Stage

    Changes:
    2021.06.08 - Added Logging into SMSTSlog
    2021.11.01 - Added logic to not overwrite Rollback values

#>


$ScriptVer = "21.11.01"
Write-Output "-----------------------------------------"
Write-Output "Starting - Inventory IPU Finish Results Script: $ScriptVer "

#Function to increment the IPUAttemps Key for each run
function Set-RegistryValueIncrement {
    [cmdletbinding()]
    param (
        [string] $path,
        [string] $Name
    )

    try { [int]$Value = Get-ItemPropertyValue @PSBoundParameters -ErrorAction SilentlyContinue } catch {}
    Set-ItemProperty @PSBoundParameters -Value ($Value + 1).ToString() 
}

#Setup TS Environment
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
    #WaaS_UpgradeBuild is set in the Task Sequence
    $tsBuild = $tsenv.Value("WaaS_UpgradeBuild")
    $registryPath = "HKLM:\$($tsenv.Value("RegistryPath"))\$tsBuild"
    Write-Output "Confirmed Running in TS with Registry Path: $registryPath"
}
catch
{
	Write-Verbose " Not running in a task sequence."
}

if ($tsenv)
    {
    if ( -not ( test-path $registryPath ) ) {new-item -ItemType directory -path $registryPath -force -erroraction SilentlyContinue | out-null}
    
    #Gets the Time in Minutes it takes to run Task Sequence  and Writes to Registry
    $Difference = ([datetime]$TSEnv.Value("SMSTS_FinishTSTime")) - ([datetime]$TSEnv.Value("SMSTS_StartTSTime")) 
    $Difference = [math]::Round($Difference.TotalMinutes)
    Write-Output " Writing IPURunTime Value to $Difference"
    New-ItemProperty -Path $registryPath -Name "IPURunTime" -Value $Difference -force | Out-Null

    #Gets the Time in Minutes it takes to Run the Setup.exe Step and Writes to Registry
    $DifferenceSetup = ([datetime]$TSEnv.Value("SMSTS_FinishUpgradeTime")) - ([datetime]$TSEnv.Value("SMSTS_StartUpgradeTime")) 
    $DifferenceSetup = [math]::Round($DifferenceSetup.TotalMinutes)
    if ((Get-Item -Path $registrypath).getValue("IPUSetupTime") -eq $null) {Write-Output " Writing IPUSetupTime Value to $DifferenceSetup"; New-ItemProperty -Path $registryPath -Name "IPUSetupTime" -Value $DifferenceSetup -force | Out-Null}


    #Gets CompatScan Results and Write Code & Friendly Name to Registry
    if ($tsenv.Value("_SMSTSSetupRollback") -ne $true)
        {
        if ($tsenv.Value("_SMSTSOSUpgradeActionReturnCode"))
            {
            [int64] $decimalreturncode = $tsenv.Value("_SMSTSOSUpgradeActionReturnCode")
            #[int64] $hexreturncode = 0xC1900210
            $hexreturncode = "{0:X0}" -f [int64]$decimalreturncode

            $WinIPURet = @(
                @{ Err = "C1900210"; Msg = 'No compatibility issues.'}
                @{ Err = "C1900208"; Msg = 'Incompatible apps or drivers.' }
                @{ Err = "C1900204"; Msg = 'Selected migration choice is not available.' }
                @{ Err = "C1900200"; Msg = 'Not eligible for Windows 10.' }
                @{ Err = "C190020E"; Msg = 'Not enough free disk space.' }
                @{ Err = "C1900107"; Msg = 'Unsupported Operating System.' }
                @{ Err = "8024200D"; Msg = 'Update Needs to be Downloaded Again.' }
                @{ Err = "800700b7"; Msg = 'File already exists.' }        
                @{ Err = "0"; Msg = 'Windows Setup completed successfully.' }
                )
        

            $ErrorMsg = $winipuret | ? err -eq $hexreturncode  | % Msg
            Write-Output " Writing IPUReturnStatus Value to $ErrorMsg"
            New-ItemProperty -path $registryPath -Name "IPUReturnStatus" -PropertyType String -Value $ErrorMsg -Force | Out-Null
            #New-ItemProperty -Path $registryPath -Name "IPUReturnCodeDec" -Value $tsenv.Value("_SMSTSOSUpgradeActionReturnCode") -force
            Write-Output " Writing IPUReturnCode Value to $hexreturncode"
            New-ItemProperty -Path $registryPath -Name "IPUReturnCode" -PropertyType String -Value $hexreturncode -Force | Out-Null
            }
        }
    Else
        {
        Write-Output " Writing IPUReturnStatus Value to Upgrade Rollback"
        New-ItemProperty -path $registryPath -Name "IPUReturnStatus" -PropertyType String -Value "Upgrade Rollback" -Force | Out-Null
        #New-ItemProperty -Path $registryPath -Name "IPUReturnCodeDec" -Value $tsenv.Value("_SMSTSOSUpgradeActionReturnCode") -force
        Write-Output " Writing IPUReturnCode Value to 253"
        New-ItemProperty -Path $registryPath -Name "IPUReturnCode" -PropertyType String -Value "253" -Force | Out-Null
        }

    if ($tsenv.Value("_SMSTSOSUpgradeActionReturnCode") -eq $null){
        Write-Output " Writing IPUReturnStatus Value to Failed Setup Step"
        New-ItemProperty -path $registryPath -Name "IPUReturnStatus" -PropertyType String -Value "Failed Setup Step" -Force | Out-Null
        }

    #Update WaaS_Status
    Write-Output " Setting Final WaaS_Stage Value.  If 'CurrentBuild = $tsBuild, Success"
    $CurrentBuild = (Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\' 'CurrentBuild')
    Write-Host "  CurrentBuild Value = $CurrentBuild"
    if ($CurrentBuild -eq $tsBuild){
        Write-Output "  Writing WaaS_Stage Value to Deployment_Success"
        New-ItemProperty -Path $registryPath -Name "WaaS_Stage" -Value "Deployment_Success" -force | Out-Null
        }
    Else { 
        Write-Output "  Writing WaaS_Stage Value to Deployment_Error"
        New-ItemProperty -Path $registryPath -Name "WaaS_Stage" -Value "Deployment_Error" -force | Out-Null
        }
    
    #Add Build Record Info so you know which Build of OS was deployed
    $UBR = (Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion' CurrentBuildNumber)+'.'+(Get-ItemPropertyValue 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion' UBR)
    Write-Output " Writing IPUBuild Value to $UBR"
    New-ItemProperty -Path $registryPath -Name "IPUBuild" -Value $UBR -Force | Out-Null


<#If Fails / Success 
    1) deletes IPURuntime, IPUSetupTime, IPUBuild
    2) Increments Failed Attempts
    3) Records FailedStepName & LastFailedCode
    4) Updates WaaS Stage
 
     #>
    #Failure
    if ($tsenv.Value("AllStepsSucceded") -eq "False")
        {
        Write-Output " Writing IPUFailedStepName Value to $($tsenv.Value("FailedStepName"))"
        New-ItemProperty -Path $registryPath -Name "IPUFailedStepName" -Value $tsenv.Value("FailedStepName") -force | Out-Null
        $WaaSKeyCurrent = get-item $registryPath 
        $RollbackTriggered = $WaaSKeyCurrent.GetValue("RollbackTSTriggered") #This is Only created if the TS Runs the Rollback Section.
        if ($RollbackTriggered -ne "TRUE"){
            Write-Output "RollbackTSTriggered value is not set, assuming not a rollback and setting to error"
            Write-Output " Writing WaaS_Stage Value to Deployment_Error"
            New-ItemProperty -Path $registryPath -Name "WaaS_Stage" -Value "Deployment_Error" -force | Out-Null

            Write-Output " Writing IPUFailedStepReturnCode Value to  $($tsenv.Value("FailedStepReturnCode"))"
            New-ItemProperty -Path $registryPath -Name "IPUFailedStepReturnCode" -Value $tsenv.Value("FailedStepReturnCode") -force | Out-Null
            }
        else
            {
            Write-Output "RollbackTSTriggered value is set to True, Assuming Rollback and that Values are already set"
            Write-Output "IPUFailedStepReturnCode set to: $($WaaSKeyCurrent.GetValue("IPUFailedStepReturnCode"))"
            Write-Output "IPUReturnStatus set to: $($WaaSKeyCurrent.GetValue("IPUReturnStatus"))"
            }
        #Delete IPURuntime if exist from previous upgrade (So it doesn't sku results)
        Write-Output " Delete IPURuntime if exist from previous upgrade (So it doesn't sku results)"
        if ((Get-Item -Path $registrypath).getValue("IPURuntime") -ne $null) {Write-Output "  Removing Item: IPURuntime"; Remove-ItemProperty -Path $registrypath -Name IPURuntime | Out-Null}
        #Delete IPURuntime if exist from previous upgrade (So it doesn't sku results)
        if ((Get-Item -Path $registrypath).getValue("IPUBuild") -ne $null) {Write-Output "  Removing Item: IPUBuild";Remove-ItemProperty -Path $registrypath -Name IPUBuild | Out-Null}
        #Delete IPURuntime if exist from previous upgrade (So it doesn't sku results)
        if ((Get-Item -Path $registrypath).getValue("IPUSetuptime") -ne $null) {Write-Output "  Removing Item: IPUSetuptime";Remove-ItemProperty -Path $registrypath -Name IPUSetuptime | Out-Null}

        #Sets IPUFailedAttempts Key and Increments after each Failure.
        Set-RegistryValueIncrement -Path $registryPath -Name IPUFailedAttempts
        Write-Output " Writing IPUFailedAttempts to $((Get-Item -Path $registrypath).getValue("IPUFailedAttempts"))"
        }
    #Success
    
    Else
        {
        Write-Output "Additional Cleanup on Successful runs: (Reports here if any)"
        #Delete IPUFailedStepName if exist from previous upgrade (So it doesn't mess with reports)
        if ((Get-Item -Path $registrypath).getValue("IPUFailedStepName") -ne $null) {Write-Output "  Removing Item: IPUFailedStepName";Remove-ItemProperty -Path $registrypath -Name IPUFailedStepName; $ExtraCleanup = $true}
        #Delete IPUFailedStepReturnCode if exist from previous upgrade (So it doesn't sku results)
        if ((Get-Item -Path $registrypath).getValue("IPUFailedStepReturnCode") -ne $null) {Write-Output "  Removing Item: IPUFailedStepReturnCode";Remove-ItemProperty -Path $registrypath -Name IPUFailedStepReturnCode; $ExtraCleanup = $true}
        if (!($ExtraCleanup)){
            Write-Output "  NO Extra Cleanup was needed"
            }
        }    
    }

Write-Output "Completed - Inventory IPU Finish Results Script: $ScriptVer "
Write-Output "-----------------------------------------"
